/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Modifier.Armor;

import com.c2h6s.etshtinker.util.slotUtil;
import com.hoshino.cti.Cti;
import com.hoshino.cti.register.CtiModifiers;
import com.hoshino.cti.register.CtiToolStats;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.DamageBlockModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;

public class PlasmaShielding
extends NoLevelsModifier
implements DamageBlockModifierHook,
InventoryTickModifierHook,
ToolStatsModifierHook {
    public static final ResourceLocation SHIELD_LOCATION = Cti.getResource("plasma_shield");
    public static final ResourceLocation CD_LOCATION = Cti.getResource("plasma_cooldown");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.TOOL_STATS, ModifierHooks.INVENTORY_TICK, ModifierHooks.DAMAGE_BLOCK);
    }

    public boolean isDamageBlocked(IToolStackView tool, ModifierEntry modifierEntry, EquipmentContext equipmentContext, EquipmentSlot equipmentSlot, DamageSource damageSource, float damage) {
        Entity entity = damageSource.m_7639_();
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            damageSource.m_19366_();
            projectile.m_146870_();
            return true;
        }
        if (damage <= 0.0f) {
            return true;
        }
        LivingEntity living = equipmentContext.getEntity();
        if (!(living.f_19853_.f_46443_ || tool.getPersistentData().getInt(SHIELD_LOCATION) <= 0 || equipmentContext.getEntity().f_19802_ > 0 || damageSource.m_19360_() || damageSource.m_19372_() || damageSource.m_19384_())) {
            tool.getPersistentData().putInt(SHIELD_LOCATION, tool.getPersistentData().getInt(SHIELD_LOCATION) - 1);
            tool.getPersistentData().putInt(CD_LOCATION, 1200);
            living.f_19802_ = Math.max(10, equipmentContext.getEntity().f_19802_);
            living.f_19853_.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_12064_, living.m_5720_(), 1.0f, 1.5f);
            if (tool.getPersistentData().getInt(SHIELD_LOCATION) <= 0) {
                living.f_19853_.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_11983_, living.m_5720_(), 1.0f, 1.2f);
            }
            return true;
        }
        return damageSource.m_19360_() || damageSource.m_19372_();
    }

    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (isCorrectSlot && !world.f_46443_) {
            if (tool.getPersistentData().getInt(SHIELD_LOCATION) < 4 && tool.getPersistentData().getInt(CD_LOCATION) <= 0) {
                tool.getPersistentData().putInt(SHIELD_LOCATION, 4);
                holder.f_19853_.m_6263_(null, holder.m_20185_(), holder.m_20186_(), holder.m_20189_(), SoundEvents.f_144243_, holder.m_5720_(), 1.0f, 0.75f);
            }
            if (tool.getPersistentData().getInt(CD_LOCATION) > 0) {
                tool.getPersistentData().putInt(CD_LOCATION, tool.getPersistentData().getInt(CD_LOCATION) - 1);
            }
        }
    }

    public static boolean isShieldActive(Player player) {
        for (EquipmentSlot slot : slotUtil.ARMOR) {
            ToolStack toolStack;
            if (!(player.m_6844_(slot).m_41720_() instanceof IModifiable) || (toolStack = ToolStack.from((ItemStack)player.m_6844_(slot))).getModifierLevel(CtiModifiers.plasma_shielding.get()) <= 0) continue;
            return toolStack.getPersistentData().getInt(SHIELD_LOCATION) > 0 && toolStack.getPersistentData().getInt(CD_LOCATION) <= 0;
        }
        return false;
    }

    public void addToolStats(IToolContext iToolContext, ModifierEntry modifierEntry, ModifierStatsBuilder modifierStatsBuilder) {
        CtiToolStats.ELECTRIC_RESISTANCE.add(modifierStatsBuilder, 1.0);
        CtiToolStats.FROZEN_RESISTANCE.add(modifierStatsBuilder, 1.0);
        CtiToolStats.SCORCH_RESISTANCE.add(modifierStatsBuilder, 1.0);
    }
}

